////////////////////////////////////////////////////////
// Tutorial 
////////////////////////////////////////////////////////

$tutWoodamt = 100; // The amount of wood you need to collect
$tutGoldamt = 50; // The amount of gold you need to collect

// Tutorial Building Experience Reward

function BuildWellXP::onMessage(%this, %type, %param)
{
   Parent::onMessage(%this, %type, %param);
   handleExperienceMessage(%this, %type, %param, 3);
}
function BuildWoodHutXP::onMessage(%this, %type, %param)
{
   Parent::onMessage(%this, %type, %param);
   handleExperienceMessage(%this, %type, %param, 5);
}
function BuildShackXP::onMessage(%this, %type, %param)
{
   Parent::onMessage(%this, %type, %param);
   handleExperienceMessage(%this, %type, %param, 3);
}
function BuildFarmXP::onMessage(%this, %type, %param)
{
   Parent::onMessage(%this, %type, %param);
   handleExperienceMessage(%this, %type, %param, 5);
}
function BuildGoldmineXP::onMessage(%this, %type, %param)
{
   Parent::onMessage(%this, %type, %param);
   handleExperienceMessage(%this, %type, %param, 5);
}

function TutorialStart::onEnter(%this)
{
   GameCamera.FlySpeed = 55;
   
   //Disable Quitting, demolishing, building, and attacking, disabling all building buttons.
   tsEnableCommand(QuitJobCmdData, false);
   tsEnableCommand(DemolishCmdData, false);
   tsEnableCommand(BuildCmdData, false);
   tsEnableCommand(AttackCmdData, false);
   tsEnableCommand(RepairCmdData, false);
   tsEnableCommand(ProduceSheepCmdData, false);
   
   ShackButton.disabled = false;
   WellButton.disabled = true;
   SaloonButton.disabled = true;
   HotelButton.disabled = true;
   GeneralButton.disabled = true;
   GranaryButton.disabled = true;
   WoodhutButton.disabled = true;
   FarmButton.disabled = true;
   BankButton.disabled = true;
   WatertowerButton.disabled = true;
   WindmillButton.disabled = true;
   OuthouseButton.disabled = true;
   RanchButton.disabled = true;
   GazeboButton.disabled = true;
   SheriffsOfficeButton.disabled = true;
   TrainstationButton.disabled = true;
   TradingpostButton.disabled = true;
   LumbermillButton.disabled = true;
   ChurchButton.disabled = true;
   BarbershopButton.disabled = true;
   LogcabinButton.disabled = true;
   WatchtowerButton.disabled = true;
   GoldMineButton.disabled = true;
   BlacksmithButton.disabled = true;
   BridgeButton.disabled = true;
   TownhallButton.disabled = true;
   StatueButton.disabled = true;
   TownbellButton.disabled = true;
   FlowerpotButton.disabled = true;
   FountainButton.disabled = true;
   WelcomesignButton.disabled = true;
   SmokehouseButton.disabled = true;
   
   //Prepping Tasks in tracker.
   tsAddQuestToTracker(true, "Movement Tutorial", "Learn the Westward II movement commands.", "Learn the Westward II movement commands.", "Reward: 3 Experience");
   tsAddQuestToTracker(true, "Building Tutorial", "Learn the Westward II building commands.", "Learn the Westward II building commands.", "Reward: 3 Experience");
   tsAddQuestToTracker(true, "Food Resource Tutorial", "Learn about Food and Employment in Westward II.", "Learn about Food and Employment in Westward II.", "Reward: 5 Experience"); 
   tsAddQuestToTracker(true, "Wood Resource Tutorial", "Learn how to harvest Wood in Westward II.", "Learn how to harvest Wood in Westward II.", " Reward: 5 Experience");
   tsAddQuestToTracker(true, "Gold Resource Tutorial", "Learn how to build Gold Mines and mine for Gold in Westward II.", "Learn how to build Gold Mines and mine for Gold in Westward II.", " Reward: 5 Experience");
   
   tsReadyQuest("Movement Tutorial");
   tsReadyQuest("Building Tutorial");
   tsReadyQuest("Food Resource Tutorial");
   tsReadyQuest("Wood Resource Tutorial");
   tsReadyQuest("Gold Resource Tutorial");
   
   // Intro Dialog
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More);
   tsAddTaskDialog("ID_TUTORIALSTARTONE", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getID());
   tsDestroyTaskDlgData(%dlgData);
   
   %heroname = getWord(herocharacter.name, 0);
   // Quest log
   if(stricmp(%heroname,"maureen") == 0)
   {
      tsAddTaskToTracker("Movement Tutorial", "Left-click on "@%heroname, "Select your hero, "@%heroname@", by left-clicking on her.");
      tsSendTaskPopUpDlg("ID_TASKNAME_TUT", "ID_TUTORIALSTARTTWOher", $TaskButton::More, "herocharacter");
   }
   else
   {
      tsAddTaskToTracker("Movement Tutorial", "Left-click on "@%heroname, "Select your hero, "@%heroname@", by left-clicking on him.");
      tsSendTaskPopUpDlg("ID_TASKNAME_TUT", "ID_TUTORIALSTARTTWO", $TaskButton::More, "herocharacter");
   }

   %marionarrow = tsCreateObj("arrow", "Marrow", $OST_NEUTRAL, "-376 -447");
   TaskModifier.strMarkVertex("TutorialTasks", "TutorialStart", $TSV_CMPLETE);
   
   // Turn off Behavior
   $AI_MONITORJOB     = false;
   $AI_MONITORHOME    = false;
   $AI_MONITORHUNGER  = false;

}
// Select task bubble
function TutorialSelect::onExit()
{
   tsRemoveObj(Marrow);

   if(firstword(getRes()) > 800)
   {
      %imagePos = "45 58";
   }
   else
   {
      %imagePos = "35 45";
   }
   %image = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/icons/taskbubble.png"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "64 64";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   }; 
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALSELECT");
   tsAddTaskDialog("ID_TUTORIALSELECT", %dlgData);
   tsSetTaskDialogImage(%image, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   %heroname = getWord(herocharacter.name, 0);
   if(stricmp(%heroname,"maureen") == 0)
   {
      // Quest log
      tsAddTaskToTracker("Movement Tutorial", "Left-click on the exclaimation point.", "See what "@%heroname@" has to say by left-clicking on the exclaimation point over her head.");
      tsCompleteTaskInTracker("Movement Tutorial", "Left-click on "@%heroname);
   }
   else
   {
      // Quest log
      tsAddTaskToTracker("Movement Tutorial", "Left-click on the exclaimation point.", "See what "@%heroname@" has to say by left-clicking on the exclaimation point over his head.");
      tsCompleteTaskInTracker("Movement Tutorial", "Left-click on "@%heroname);

   }
}
// Drag move
function TutorialMoveTalk::onEnter(%this)
{
   if(firstword(getRes()) > 800)
   {
      %imagePos = "22 65";
   }
   else
   {
      %imagePos = "17 51";
   }
   %image = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutmove.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "120 85";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, false, "ID_TUTORIALMOVETALK");
   tsAddTaskDialog("ID_TUTORIALMOVETALK", %dlgData);
   tsSetTaskDialogImage(%image, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   TaskModifier.strMarkVertex("TutorialTasks", "TutorialMoveTalk", $TSV_CMPLETE);
}

function TutorialMoveTalkArrow::onExit(%this)
{
   %movearrow = tsCreateObj("arrow", "Move", $OST_NEUTRAL, "-396 -434", "Move");
   %heroname = getWord(herocharacter.name, 0);
   // Quest Log
   tsAddTaskToTracker("Movement Tutorial", "Move over by the water barrel.", "Left-click and drag "@%heroname@" south of the water barrel to move to it.");
   tsCompleteTaskInTracker("Movement Tutorial", "Left-click on the exclaimation point.");
}
// Move again
function TutorialMoveArrive::onExit(%this)
{
   tsRemoveObj(Move);
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALMOVEARRIVE");
   tsAddTaskDialog("ID_TUTORIALMOVEARRIVE", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   %heroname = getWord(herocharacter.name, 0);
   // Quest Log
   tsAddTaskToTracker("Movement Tutorial", "Move "@%heroname@" to the Road Sign.", "Move "@%heroname@" over to the Road Sign to the south-east.");
   tsCompleteTaskInTracker("Movement Tutorial", "Move over by the water barrel.");
   
}

function TutorialMoveArriveArrow::onExit(%this)
{
   %movetwoarrow = tsCreateObj("arrow", "MoveTwo", $OST_NEUTRAL, "-405 -407");
   tsMoveCameraToObject("roadsign1", false);
   TaskModifier.strMarkVertex("TutorialTasks", "TutorialMoveArriveArrow", $TSV_CMPLETE);
}

function TutorialScanArrive::onExit(%this)
{   
   tsRemoveObj(MoveTwo);
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, false, "ID_TUTORIALSCANMOVE");
   tsAddTaskDialog("ID_TUTORIALSCANMOVE", %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   %heroname = getWord(herocharacter.name, 0);
   // Quest Log
   tsAddTaskToTracker("Movement Tutorial", "Move "@%heroname@" to the Citizen.", "Move "@%heroname@" further south-east to the Citizen.");
   tsCompleteTaskInTracker("Movement Tutorial", "Move "@%heroname@" to the Road Sign.");
}

function TutorialScanArriveArrow::onExit(%this)
{
   tsMoveCameraToObject("Settler1", false);
   %scanarrow = tsCreateObj("arrow", "Scan", $OST_NEUTRAL, "-417 -380");
   TaskModifier.strMarkVertex("TutorialTasks", "Movecamback", $TSV_AVAIL);
}

function Movecamback::onExit(%this)
{
   tsMoveCameraToObject(heroCharacter.getID(), false);
   TaskModifier.strMarkVertex("TutorialTasks", "Movecamback", $TSV_CMPLETE);
}
// Teach map movement
function TutorialMapmovement::onExit(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More, "ID_TUTORIALMapMovement");
   tsAddTaskDialog("ID_TUTORIALMapMovement", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "herocharacter");
   tsDestroyTaskDlgData(%dlgData);
}

function TutorialMoveTwo::onExit(%this)
{    
   tsRemoveObj(Scan);
   // Zoom commands
   if(firstword(getRes()) > 800)
   {
      %imagePos = "29 60";
   }
   else
   {
      %imagePos = "22 47";
   }
   %image = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutzoom.png"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "107 149";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData1 = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::Okay, "id_tutorialzoom");
   tsAddTaskDialog("id_tutorialzoom", %dlgData1);
   tsSetTaskDialogImage(%image, %dlgData1);
   tsSendTaskDlgMsg(%dlgData1, "herocharacter");
   tsDestroyTaskDlgData(%dlgData1);
   // Click Task bubble   
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, false, "ID_TUTORIALSCANARRIVEONE");
   tsAddTaskDialog("ID_TUTORIALSCANARRIVEONE", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Settler1");
   tsDestroyTaskDlgData(%dlgData);
   %heroname = getWord(herocharacter.name, 0);
   // Quest Log 
   tsAddTaskToTracker("Building Tutorial", "Click on the exclaimation point.", "See what the Citizen has to say by clicking on the exclaimation point over his head.");
   tsCompleteTaskInTracker("Movement Tutorial", "Move "@%heroname@" to the Citizen.");
   tsSelectQuestButton("Building Tutorial");
   // Reward
   tsModifyResource($Resource::Experience, 3, true);
   SendProductionToClient(herocharacter, "3 experience");
}
// Build button
function TutorialScanArriveTwo::onExit(%this)
{      
   if(firstword(getRes()) > 800)
   {
      %imagePos = "27 58";
      %image1Pos = "28 57";
      %image2Pos = "24 67";
   }
   else
   {
      %imagePos = "21 45";
      %image1Pos = "21 45";
      %image2Pos = "19 52";
   }
   %image = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutbuild.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "111 107";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutshackbuild.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "-2 0";
      extent = "110 114";
      position = %image1Pos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %image2 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutplace.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "-2 0";
      extent = "106 106";
      position = %image2Pos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
  
   %dlgData1 = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More);
   tsAddTaskDialog("ID_TUTORIALBuild", %dlgData1);
   tsSetTaskDialogImage(%image, %dlgData1);
   tsSendTaskDlgMsg(%dlgData1, HeroCharacter.getID());
   tsDestroyTaskDlgData(%dlgData1);
   %dlgData2 = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More);
   tsAddTaskDialog("ID_TUTORIALBuildTwo", %dlgData2);
   tsSetTaskDialogImage(%image1, %dlgData2);
   tsSendTaskDlgMsg(%dlgData2, HeroCharacter.getID());
   tsDestroyTaskDlgData(%dlgData2);
   %dlgData3 = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALBuildThree");
   tsAddTaskDialog("ID_TUTORIALBuildThree", %dlgData3);
   tsSetTaskDialogImage(%image2, %dlgData3);
   tsSendTaskDlgMsg(%dlgData3, HeroCharacter.getID());
   tsDestroyTaskDlgData(%dlgData3);
   %heroname = getWord(herocharacter.name, 0);
   // Quest Log
   tsAddTaskToTracker("Building Tutorial", "Select "@%heroname@" to build.", "Select your Hero, "@%heroname@", to build the Shack.");
   tsAddTaskToTracker("Building Tutorial", "Build a Shack.", "Build a Shack for the Citizen.");
   tsCompleteTaskInTracker("Building Tutorial", "Click on the exclaimation point.");
   
}

function TutorialScanArriveExecute::onEnter(%this)
{
   tsEnableCommand(BuildCmdData, true);
   tsBlinkButton(CharCmdButton0, 0.2, 0.2, 60);
   tsBlinkButton(ShackButton, 0.2, 0.2, 80);
   TaskModifier.strMarkVertex("TutorialTasks", "TutorialScanArriveExecute", $TSV_CMPLETE);
   
   // give the player enough resources to build a shack
   %gold = Shack.goldCost;
   %wood = Shack.woodCost;
   tsModifyResource($Resource::Gold, %gold, true);
   tsModifyResource($Resource::Wood, %wood, true);
}
// Build Shack
function TutorialShack::onExit(%this)
{
   
   ShackButton.disabled = true;
   tsConvertObjTeam("Settler1", $OST_PLAYER);
   tsSkinObj("Settler1", "base");
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, false, "ID_TUTORIALSHACK");
   tsAddTaskDialog("ID_TUTORIALSHACK", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Settler1");
   tsDestroyTaskDlgData(%dlgData);
   %heroname = getWord(herocharacter.name, 0);
   // Quest Log
   tsAddTaskToTracker("Food Resource Tutorial", "Pick up berries.", "Move a character to one of the berry bushes to collect Food.");
   tsCompleteTaskInTracker("Building Tutorial", "Select "@%heroname@" to build.");
   tsCompleteTaskInTracker("Building Tutorial", "Build a Shack.");
   tsSelectQuestButton("Food Resource Tutorial");
   // Reward
   tsModifyResource($Resource::Experience, 3, true);
   SendProductionToClient(herocharacter, "3 experience");
   
}
function TutorialShackArrow::onExit(%this)
{
   %berryarrow = tsCreateObj("arrow", "Berry", $OST_NEUTRAL, "-423 -375");
   tsRemoveObj(berryrock);
   %tutbush = tsCreateObj("berrybush", "TastyBerries", $OST_NEUTRAL, "-422 -374");
   if(firstword(getRes()) > 800)
   {
      %imagePos = "225 170";
      %imageExtent = "170 115";
      %image2Pos = "26 50";
   }
   else
   {
      %imagePos = "190 145";
      %imageExtent = "135 90";
      %image2Pos = "20 39";
   }
   // Dialog images
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutfood.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "115 138";
      position = %image2Pos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %image2 = new SLImage()
   {
      stateUp = "~/client/ui/tutorialImages/tutbushpickup.jpg";
      extent = %imageExtent;
      iconEnabled = "~/client/ui/tutorialImages/tutbushprop.png";
      iconOffset = "-180 -100";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData1 = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More);
   tsAddTaskDialog("ID_TUTORIALFoodResource", %dlgData1);
   tsSetTaskDialogImage(%image1, %dlgData1);
   tsSendTaskDlgMsg(%dlgData1, "Settler1");
   tsDestroyTaskDlgData(%dlgData1);
   %dlgData2 = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALCollectBerry");
   tsAddTaskDialog("ID_TUTORIALCollectBerry", %dlgData2);
   tsSetTaskDialogImage(%image2, %dlgData2);
   tsSendTaskDlgMsg(%dlgData2, "Settler1");
   tsDestroyTaskDlgData(%dlgData2);
}

function TutorialPickupFood::onMessage(%this, %msg, %param)
{
   Parent::onMessage(%this, %msg, %param);
   if (%this.isMarkedComplete())
   {
      tsRemoveObj(Berry);
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, false, "ID_TUTORIALPICKUPFOOD");
      tsAddTaskDialog("ID_TUTORIALPICKUPFOOD", %dlgData);
      tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
      tsDestroyTaskDlgData(%dlgData);
      %heroname = getWord(herocharacter.name, 0);
      //Quest Log
      tsAddTaskToTracker("Food Resource Tutorial", "Select a character to build.", "To build a Building, first select a character.");
      tsAddTaskToTracker("Food Resource Tutorial", "Build a Well.", "Build a Well to unlock the Farm.");
      tsAddTaskToTracker("Food Resource Tutorial", "Build a Farm.", "Build a Farm.");
      tsCompleteTaskInTracker("Food Resource Tutorial", "Pick up berries.");
   
   }
}

function TutorialWellBuild::onExit(%this)
{
   
   if(firstword(getRes()) > 800)
   {
      %imagePos = "27 58";
      %image2Pos = "32 58";
   }
   else
   {
      %imagePos = "21 45";
      %image2Pos = "25 45";
   }
   // Build Button
   %image = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutbuild.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "-2 0";
      extent = "111 107";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More);
   tsAddTaskDialog("ID_TUTORIALWellSelect", %dlgData);
   tsSetTaskDialogImage(%image, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   // Build well
   %image2 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutwellbuild.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "110 200";
      position = %image2Pos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALWellBuild");
   tsAddTaskDialog("ID_TUTORIALWellBuild", %dlgData);
   tsSetTaskDialogImage(%image2, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
}

function TutorialWellStart::onExit(%this)
{
   
   // give the player enough resources to build a well
   %gold = well.goldCost;
   %wood = well.woodCost;
   tsModifyResource($Resource::Gold, %gold, true);
   tsModifyResource($Resource::Wood, %wood, true);
   
   WellButton.disabled = false;
   tsBlinkButton(CharCmdButton0, 0.2, 0.2, 80);
   tsBlinkButton(WellButton, 0.2, 0.2, 80);
}

function TutorialWell::onExit(%this)
{
   
   WellButton.disabled = true;
   FarmButton.disabled = true;
   if(firstword(getRes()) > 800)
   {
      %imagePos = "24 53";
   }
   else
   {
      %imagePos = "19 41";
   }
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutfarmbuild.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "141 209";
      position = %imagePos;
      input = "0";
      onTop = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, false, "ID_TUTORIALWELL");
   tsAddTaskDialog("ID_TUTORIALWELL", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   // quest log
   tsCompleteTaskInTracker("Food Resource Tutorial", "Build a Well.");
}

function TutorialWellBlink::onExit(%this)
{
   
   // give the player enough resources to build a farm
   %gold = Farm.goldCost;
   %wood = Farm.woodCost;
   tsModifyResource($Resource::Gold, %gold, true);
   tsModifyResource($Resource::Wood, %wood, true);
   
   FarmButton.disabled = false;
   tsBlinkButton(CharCmdButton0, 0.2, 0.2, 40);
   tsBlinkButton(FarmButton, 0.2, 0.2, 30);
}

function TutorialFarm::onExit(%this)
{  
    FarmButton.disabled = true;
      
   if(firstword(getRes()) > 800)
   {
      %imagePos = "222 171";
      %image2Pos = "34 78";
   }
   else
   {
      %imagePos = "173 134";
      %image2Pos = "27 61";
   }
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutemploy.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "167 116";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More);
   tsAddTaskDialog("ID_TUTORIALFARM", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Settler1");
   tsDestroyTaskDlgData(%dlgData);
   %image2 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutemployhammer.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "96 47";
      position = %image2Pos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData2 = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false,  "ID_TUTORIALEmployHammer");
   tsAddTaskDialog("ID_TUTORIALEmployHammer", %dlgData2);
   tsSetTaskDialogImage(%image2, %dlgData2);
   tsSendTaskDlgMsg(%dlgData2, "Settler1");
   tsDestroyTaskDlgData(%dlgData2);
   // Quest Log
   tsAddTaskToTracker("Food Resource Tutorial", "Employ the Citizen at the Farm.", "Select the Citizen and drag him to the Farm to employ him there.");
   tsCompleteTaskInTracker("Food Resource Tutorial", "Select a character to build.");
   tsCompleteTaskInTracker("Food Resource Tutorial", "Build a Farm.");
}
// Build second shack
function TutorialEmployFarm::onExit(%this)
{
   
   tsSendTaskPopUpDlg("ID_TASKNAME_TUT", "ID_TUTORIALHeroCantEmploy", $TaskButton::More, "herocharacter");   
   if(firstword(getRes()) > 800)
   {
      %imagePos = "28 57";
   }
   else
   {
      %imagePos = "22 45";
   }
   %image2 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutshackbuild2.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "89 183";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, false, "ID_TUTORIALEMPLOYFARM");
   tsAddTaskDialog("ID_TUTORIALEMPLOYFARM", %dlgData);
   tsSetTaskDialogImage(%image2, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "herocharacter");
   tsDestroyTaskDlgData(%dlgData);
   // Quest Log   
   tsAddTaskToTracker("Food Resource Tutorial", "Build another Shack.", "Build a second Shack.");
   tsCompleteTaskInTracker("Food Resource Tutorial", "Employ the Citizen at the Farm.");
}
// Employ second citizen
function TutorialUnlockshack2::onExit(%this)
{
   // give the player enough resources to build a shack
   %gold = Shack.goldCost;
   %wood = Shack.woodCost;
   tsModifyResource($Resource::Gold, %gold, true);
   tsModifyResource($Resource::Wood, %wood, true);
   ShackButton.disabled = false;
}
// Employ second citizen
function TutorialSecondShack::onExit(%this)
{
   tsAddTaskToTracker("Food Resource Tutorial", "Employ the new Citizen.", "Employ the new Citizen at the Farm.");
   tsCompleteTaskInTracker("Food Resource Tutorial", "Build another Shack.");
   ShackButton.disabled = true;
   if(firstword(getRes()) > 800)
   {
      %imagePos = "222 171";
   }
   else
   {
      %imagePos = "173 134";
   }
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutemploy.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "167 116";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, false, "ID_TUTORIALSECONDSHACK");
   tsAddTaskDialog("ID_TUTORIALSECONDSHACK", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
}

function TutorialSecondEmploy::onExit(%this)
{
   if(firstword(getRes()) > 800)
   {
      %imagePos = "25 67";
   }
   else
   {
      %imagePos = "20 52";
   }
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutxp.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "106 92";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, false, "ID_TUTORIALSECONDEMPLOY");
   tsAddTaskDialog("ID_TUTORIALSECONDEMPLOY", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getID());
   tsDestroyTaskDlgData(%dlgData);
   // Quest Log   
   tsAddTaskToTracker("Wood Resource Tutorial", "Unlock the Wood Hut.", "Use the Store button to unlock the Wood Hut.");
   tsCompleteTaskInTracker("Food Resource Tutorial", "Employ the new Citizen.");
   tsSelectQuestButton("Wood Resource Tutorial");
   // Reward
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(herocharacter, "5 experience");
}

function TutorialSecondEmployBlink::onExit(%this)
{
   if(firstword(getRes()) > 800)
   {
      %imagePos = "33 57";
   }
   else
   {
      %imagePos = "26 45";
   }
   %image2 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutxpwoodhut.png"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "394 224";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData2 = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALXpStore");
   tsAddTaskDialog("ID_TUTORIALXpStore", %dlgData2);
   tsSetTaskDialogImage(%image2, %dlgData2);
   tsSendTaskDlgMsg(%dlgData2, HeroCharacter.getID());
   tsDestroyTaskDlgData(%dlgData2);
   
   %gold = 20;
   tsModifyResource($Resource::Gold, %gold, true);
   
   tsBlinkButton(XP, 0.2, 0.2, 70);
   WoodhutButton.disabled = false;
   XPBuyWoodhut.reqCheck0 = true;
}

function TutorialXPLumber::onMessage(%this, %msg, %param)
{
   Parent::onMessage(%this, %msg, %param);
   if (%this.isMarkedComplete())
   {
   
      if(firstword(getRes()) > 800)
      {
         %imagePos = "25 58";
         %image2Pos = "22 49";
      }
      else
      {
         %imagePos = "20 45";
         %image2Pos = "17 38";
      }
      %image1 = new SLImage()
      {
         stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
         iconEnabled = "~/client/ui/tutorialImages/tutbuildwoodhut.jpg"; // Icon image used as main image automatic resizing with resolution change.
         iconOffset = "0 0";
         extent = "105 183";
         position = %imagePos;
         input = "0";
         onTop = "0";
         HorizSizing = "relative";
         VertSizing = "relative";
      };
      // Build woodhut
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More);
      tsAddTaskDialog("ID_TUTORIALXPLUMBER", %dlgData);
      tsSetTaskDialogImage(%image1, %dlgData);
      tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
      tsDestroyTaskDlgData(%dlgData);
      // Teach woodhut
      %image2 = new SLImage()
      {
         stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
         iconEnabled = "~/client/ui/tutorialImages/tuttreeprop.jpg"; // Icon image used as main image automatic resizing with resolution change.
         iconOffset = "0 0";
         extent = "112 217";
         position = %image2Pos;
         input = "0";
         HorizSizing = "relative";
         VertSizing = "relative";
      };
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More);
      tsAddTaskDialog("ID_TUTORIALWoodhutTrees", %dlgData);
      tsSetTaskDialogImage(%image2, %dlgData);
      tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
      tsDestroyTaskDlgData(%dlgData);
      // Show good location
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALWoodhutplace");
      tsAddTaskDialog("ID_TUTORIALWoodhutplace", %dlgData);
      tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
      tsDestroyTaskDlgData(%dlgData);
      // Remove rock props and spawn arrow
      %woodhutarrow = tsCreateObj("arrow", "woodarrow", $OST_NEUTRAL, "-440 -371", "woodarrow");
      tsRemoveObj(woodrock1);
      tsRemoveObj(woodrock2);
      tsRemoveObj(woodrock3);
      // Quest Log
      tsAddTaskToTracker("Wood Resource Tutorial", "Build a Wood Hut.", "Build a Wood Hut near some trees.");
      tsCompleteTaskInTracker("Wood Resource Tutorial", "Unlock the Wood Hut.");
    }
}
// Move to Wood arrow 
function TutWoodhutPlacement::onExit(%this)
{
   %gold = Woodhut.goldCost;
   %wood = Woodhut.woodCost;
   tsModifyResource($Resource::Gold, %gold, true);
   tsModifyResource($Resource::Wood, %wood, true);
   
   tsMoveCameraToObject("woodarrow", false);
   TaskModifier.strMarkVertex("TutorialTasks", "TutWoodhutPlacement", $TSV_CMPLETE);
}
function TutWoodhutMoveback::onExit(%this)
{
   tsMoveCameraToObject(HeroCharacter.getId(), false);
   TaskModifier.strMarkVertex("TutorialTasks", "TutWoodhutMoveback", $TSV_CMPLETE);
}
function TutorialLumberBuild::onExit(%this)
{
   tsRemoveObj("woodarrow");
   WoodhutButton.disabled = true;
   // Quit job Dialogue
   if(firstword(getRes()) > 800)
   {
      %imagePos = "24 59";
   }
   else
   {
      %imagePos = "19 46";
   }
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutquitjob.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "109 188";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, false, "ID_TUTORIALLUMBERBUILD");
   tsAddTaskDialog("ID_TUTORIALLUMBERBUILD", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   // Quest log
   tsAddTaskToTracker("Wood Resource Tutorial", "Employ a Citizen at the Wood Hut.", "Have a Citizen quit their job at the Farm and employ them at the Wood Hut.");
   tsCompleteTaskInTracker("Wood Resource Tutorial", "Build a Wood Hut.");
}

function TutorialLumberBuildBlink::onExit(%this)
{
   // Get farm id
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("farm", "bldg", %objList);
   %object = %objList.getID(0);
   tsDestroyObjList(%objList); // Destroy object list
   
   tsMoveCameraToObject(%object, false);
   tsEnableCommand(QuitJobCmdData, true);
   tsBlinkButton(CharCmdButton3, 0.2, 0.2, 80);
}

function TutorialLumberComplete::onMessage(%this, %msg, %param)
{
   Parent::onMessage(%this, %msg, %param);
   if(%this.isMarkedComplete())
   {
      if(firstword(getRes()) > 800)
      {
         %imagePos = "29 62";
      }
      else
      {
         %imagePos = "23 48";
      }
      // Extra wood
      %image1 = new SLImage()
      {
         stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
         iconEnabled = "~/client/ui/tutorialImages/tutextrawood.jpg"; // Icon image used as main image automatic resizing with resolution change.
         iconOffset = "0 0";
         extent = "101 147";
         position = %imagePos;
         input = "0";
         HorizSizing = "relative";
         VertSizing = "relative";
      };
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More, "ID_TUTORIALWoodhutCOMPLETE");
      tsAddTaskDialog("ID_TUTORIALLUMBERBUILDCOMPLETE", %dlgData);
      tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
      tsDestroyTaskDlgData(%dlgData);
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALExtraWoodprops");
      tsAddTaskDialog("ID_TUTORIALExtraWoodprops", %dlgData);
      tsSetTaskDialogImage(%image1, %dlgData);
      tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
      tsDestroyTaskDlgData(%dlgData);
      //Quest log
      tsAddTaskToTracker("Wood Resource Tutorial", "Collect "@$tutWoodamt@" Wood.", "Collect "@$tutWoodamt@" Wood by employing Citizens at the Wood Hut and picking up Wood piles.");
      tsCompleteTaskInTracker("Wood Resource Tutorial", "Employ a Citizen at the Wood Hut.");
   }
}

function TutorialWoodComplete::onUpdate(%this)
{
   %resourceCount = rsGetResourceCount($Resource::Wood);
   if(%resourceCount >= $tutWoodamt)
   {
      TaskModifier.StrMarkVertex("TutorialTasks", "TutorialWoodComplete", $TSV_CMPLETE);
   }
}

function TutorialWoodCompleteTwo::onEnter(%this)
{
   if(firstword(getRes()) > 800)
   {
      %imagePos = "33 57";
   }
   else
   {
      %imagePos = "26 45";
   }
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutxpgoldmine.png"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "394 224";
      position = %imagePos;
      input = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALWOODCOMPLETE");
   tsAddTaskDialog("ID_TUTORIALWOODCOMPLETE", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   
   TaskModifier.StrMarkVertex("TutorialTasks", "TutorialWoodCompleteTwo", $TSV_CMPLETE);
   // Quest Log
   tsAddTaskToTracker("Gold Resource Tutorial", "Unlock the Gold Mine.", "Unlock a Gold Mine from the Experience Store.");
   tsCompleteTaskInTracker("Wood Resource Tutorial", "Collect "@$tutWoodamt@" Wood.");
   
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(herocharacter, "5 experience");
}

function TutorialWoodCompleteTwo::onExit(%this)
{
   GoldmineButton.disabled = false;
   XPBuyGoldMine.reqCheck0 = true;
   //Flash store button
   tsBlinkButton(XP, 0.2, 0.2, 80);
}

function TutorialXPMine::onMessage(%this, %msg, %param)
{
   Parent::onMessage(%this, %msg, %param);
   if (%this.isMarkedComplete())
   {
      if(firstword(getRes()) > 800)
      {
         %imagePos = "33 67";
         %image2Pos = "18 57";
      }
      else
      {
         %imagePos = "26 52";
         %image2Pos = "14 45";
      }  
      //build goldmine
      %image1 = new SLImage()
      {
         stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
         iconEnabled = "~/client/ui/tutorialImages/tutbuildmine.jpg"; // Icon image used as main image automatic resizing with resolution change.
         iconOffset = "0 0";
         extent = "103 181";
         position = %imagePos;
         input = "0";
         HorizSizing = "relative";
         VertSizing = "relative";
      };
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More, "ID_TUTORIALXPMINE");
      tsAddTaskDialog("ID_TUTORIALXPMINE", %dlgData);
      tsSetTaskDialogImage(%image1, %dlgData);
      tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
      tsDestroyTaskDlgData(%dlgData);
      //place goldmine
      %image2 = new SLImage()
      {
         stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
         iconEnabled = "~/client/ui/tutorialImages/tutmineplace.jpg"; // Icon image used as main image automatic resizing with resolution change.
         iconOffset = "0 0";
         extent = "156 240";
         position = %image2Pos;
         input = "0";
         onTop = "0";
         HorizSizing = "relative";
         VertSizing = "relative";
      };
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALXPMINE2");
      tsAddTaskDialog("ID_TUTORIALXPMINE2", %dlgData);
      tsSetTaskDialogImage(%image2, %dlgData);
      tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
      tsDestroyTaskDlgData(%dlgData);
      
      // Remove Goldmine rocks
      tsRemoveObj(minerock1);
      tsRemoveObj(minerock2);
      tsRemoveObj(minerock3);
      tsRemoveObj(minerock4);
      tsRemoveObj(minerock5);
      
      %gold = Goldmine.goldCost;
      tsModifyResource($Resource::Gold, %gold, true);

      // Quest log
      tsAddTaskToTracker("Gold Resource Tutorial", "Build a Gold Mine.", "Build a Gold Mine on the Gold Vein.");
      tsCompleteTaskInTracker("Gold Resource Tutorial", "Unlock the Gold Mine.");   
   }
}

function TutMineUnlockMove::onExit(%this)
{
   // move camera to tutgoldmine.
   tsMoveCameraToObject("tutgoldmine", false);
   TaskModifier.strMarkVertex("TutorialTasks", "Movecamback", $TSV_CMPLETE);
}
function TutMineUnlockMoveBack::onExit(%this)
{
   tsMoveCameraToObject(HeroCharacter.getId(), false);
   TaskModifier.strMarkVertex("TutorialTasks", "TutMineUnlockMoveBack", $TSV_CMPLETE);
}

function TutorialMineBuild::onExit(%this)
{
   
   if(firstword(getRes()) > 800)
   {
      %imagePos = "28 51";
   }
   else
   {
      %imagePos = "22 40";
   }
   // Quit job at woodhut employ goldmine 
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutquitwood.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "104 175";
      position = %imagePos;
      input = "0";
      onTop = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, false, "ID_TUTORIALMINEBUILD");
   tsAddTaskDialog("ID_TUTORIALMINEBUILD", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   // Quest Log
   tsAddTaskToTracker("Gold Resource Tutorial", "Employ a Citizen at the Gold Mine.", "Have a Citizen quit their job at the Wood Hut and employ them at the Gold Mine.");
   tsCompleteTaskInTracker("Gold Resource Tutorial", "Build a Gold Mine.");
   GoldmineButton.disabled = true;
}

function TutorialMineBuildBlink::onExit(%this)
{
   //Blink Quit-Job button.
   // Get Woodhut id
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("Woodhut", "bldg", %objList);
   %object = %objList.getID(0);
   tsDestroyObjList(%objList); // Destroy object list
   
   tsMoveCameraToObject(%object, false);
   tsBlinkButton(CharCmdButton3, 0.2, 0.2, 80);
}

function TutorialMineComplete::onMessage(%this, %msg, %param)
{
   Parent::onMessage(%this, %msg, %param);
   if (%this.isMarkedComplete()) 
   {
      tsAddTaskToTracker("Gold Resource Tutorial", "Collect "@$tutGoldamt@" Gold.", "Collect "@$tutGoldamt@" Gold by employing Citizens at the Gold Mine.");
      tsCompleteTaskInTracker("Gold Resource Tutorial", "Employ a Citizen at the Gold Mine.");
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALMINEBUILDCOMPLETE");
      tsAddTaskDialog("ID_TUTORIALMINEBUILDCOMPLETE", %dlgData);
      tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
      tsDestroyTaskDlgData(%dlgData);
   }
}
// Trigger to spawn gunslingers
function TutorialRaidStart::onUpdate(%this)
{
   %resourceCountOne = rsGetResourceCount($Resource::Gold);
   if(%resourceCountOne > 10)
   {
      TaskModifier.StrMarkVertex("TutorialTasks", "TutorialRaidStart", $TSV_CMPLETE);
      TaskModifier.StrMarkVertex("TutorialTasks", "TutorialGoldComplete", $TSV_AVAIL);
   }
}

//Spawn two gunslingers to help with Combat Tutorial. Move them to Mine.
function TutorialRaidGunslinger::onEnter(%this)
{
   tsCreateObj("malegunslinger", "Yance", $OST_NEUTRAL, "-362 -270", "Yance");
   tsNameObj("Yance", "Yance Aiden");
   tsMoveObjToTarget("Yance", "-350 -360");
   tsCreateObj("femalegunslinger", "Elvira", $OST_NEUTRAL, "-361 -272", "Elvira");
   tsNameObj("Elvira", "Elvira Helpenhal");
   tsMoveObjToTarget("Elvira", "-355 -360");
   TaskModifier.strMarkVertex("TutorialTasks", "TutorialRaidGunslinger", $TSV_CMPLETE);
}

//Tell you to move your Hero to the Mine as well.      
function TutorialRaidGunArrive::onExit(%this)
{
   // Gunslinger Intro
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, false, "ID_TUTORIALRAIDGUNARRIVE");
   tsAddTaskDialog("ID_TUTORIALRAIDGUNARRIVE", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Yance");
   tsDestroyTaskDlgData(%dlgData);

}
function TutorialHerobtn::onExit(%this)
{
    
   if(firstword(getRes()) > 800)
   {
      %imagePos = "45 65";
   }
   else
   {
      %imagePos = "35 51";
   }
   %heroID = heroCharacter.getID();
	%heroname = %heroID.getType();
	%heroselect = "~/client/ui/icons/"@%heroname@"select.png";
   
   // Quick find button for hero
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = %heroselect;
      iconOffset = "0 0";
      extent = "59 66";
      position = %imagePos;
      input = "0";
      onTop = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More, "ID_TUTORIALFindHero");
   tsAddTaskDialog("ID_TUTORIALFindHero", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Yance");
   tsDestroyTaskDlgData(%dlgData);
   
   %goldminearrow = tsCreateObj("arrow", "minearrow", $OST_NEUTRAL, "-346 -359", "minearrow");
   //Questlog
   tsAddQuestToTracker(true, "Combat Tutorial", "Learn about combat in Westward II.", "Learn about combat in Westward II.", "Reward: 5 Experience");
   tsReadyQuest("Combat Tutorial");
   tsAddTaskToTracker("Combat Tutorial", "Defend your Gold Mine.", "Defend your Gold Mine from attack.");
   tsAddTaskToTracker("Combat Tutorial", "Move your Hero to the Gold Mine.", "Move your Hero to the Gunslingers at the Gold Mine.");
   tsSelectQuestButton("Combat Tutorial");
}

function TutorialHeroArrive::onExit(%this)
{
   // Mini Map Find Next Button Tutorial
   if(firstword(getRes()) > 800)
   {
      %imagePos = "39 75";
      %image5Pos = "31 56";
   }
   else
   {
      %imagePos = "30 59";
      %image5Pos = "24 44";
   }
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutnextunemploy.png";
      iconOffset = "0 0";
      extent = "76 80";
      position = %imagePos;
      input = "0";
      onTop = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %image2 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutnextciv.png";
      iconOffset = "0 0";
      extent = "76 80";
      position = %imagePos;
      input = "0";
      onTop = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %image3 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutnextbuilding.png";
      iconOffset = "0 0";
      extent = "76 80";
      position = %imagePos;
      input = "0";
      onTop = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %image4 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutnextgun.png";
      iconOffset = "0 0";
      extent = "76 80";
      position = %imagePos;
      input = "0";
      onTop = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %image5 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutminimap.png";
      iconOffset = "0 0";
      extent = "99 113";
      position = %image5Pos;
      input = "0";
      onTop = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More, "ID_TUTORIALNextJobless");
   tsAddTaskDialog("ID_TUTORIALNextJobless", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "herocharacter");
   tsDestroyTaskDlgData(%dlgData);
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More, "ID_TUTORIALNextCitizen");
   tsAddTaskDialog("ID_TUTORIALNextCitizen", %dlgData);
   tsSetTaskDialogImage(%image2, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "herocharacter");
   tsDestroyTaskDlgData(%dlgData);
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More, "ID_TUTORIALNextBuilding");
   tsAddTaskDialog("ID_TUTORIALNextBuilding", %dlgData);
   tsSetTaskDialogImage(%image3, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "herocharacter");
   tsDestroyTaskDlgData(%dlgData);
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More, "ID_TUTORIALNextCombat");
   tsAddTaskDialog("ID_TUTORIALNextCombat", %dlgData);
   tsSetTaskDialogImage(%image4, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "herocharacter");
   tsDestroyTaskDlgData(%dlgData);
   //MINImap
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::Okay, "ID_TUTORIALminimap");
   tsAddTaskDialog("ID_TUTORIALminimap", %dlgData);
   tsSetTaskDialogImage(%image5, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "herocharacter");
   tsDestroyTaskDlgData(%dlgData);
   
   // Gunslinger Text
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, false, "ID_TUTORIALBanditIntro");
   tsAddTaskDialog("ID_TUTORIALBanditIntro", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Elvira");
   tsDestroyTaskDlgData(%dlgData);
   tsRemoveObj("minearrow");
   
   //Quest log
   tsCompleteTaskInTracker("Combat Tutorial", "Move your Hero to the Gold Mine.");
}
function TutorialLassoSelect::onExit()
{
   // Lasso Select 
   if(firstword(getRes()) > 800)
   {
      %imagePos = "23 64";
   }
   else
   {
      %imagePos = "18 50";
   }
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutlasso.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "130 104";
      position = %imagePos;
      input = "0";
      onTop = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALLassoteach");
   tsAddTaskDialog("ID_TUTORIALLassoteach", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Elvira");
   tsDestroyTaskDlgData(%dlgData);
   
   tsConvertObjTeam("Yance", $OST_PLAYER);
   tsConvertObjTeam("Elvira",$OST_PLAYER);
   //Quest Log
   tsAddTaskToTracker("Combat Tutorial", "Lasso-Select both Gunslingers.", "Use Lasso-Select to select both Gunslingers at once.");
}

function TutorialCreateBandit::onExit()
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALLassosuccess");
   tsAddTaskDialog("ID_TUTORIALLassosuccess", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Elvira");
   tsDestroyTaskDlgData(%dlgData);
   tsCreateObj("Malebandit", "Grubby", $OST_NEUTRAL, "-362 -270", "Grubby");
   tsNameObj("Grubby", "Grubby Franklin");
   tsMoveObjToTarget("Grubby", "-355 -333");
   //Quest Log
   tsCompleteTaskInTracker("Combat Tutorial", "Lasso-Select both Gunslingers.");
}
function TutorialLassoTeach::onExit(%this)
{
   
   if(firstword(getRes()) > 800)
   {
      %imagePos = "23 65";
   }
   else
   {
      %imagePos = "18 51";
   }
   // Bandit Text
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALRAIDBANDITARRIVE");
   tsAddTaskDialog("ID_TUTORIALRAIDBANDITARRIVE", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Grubby");
   tsDestroyTaskDlgData(%dlgData);
   
   // Lasso Select + Combat
   %image1 = new SLImage()
   {
      stateUp = "~/client/ui/icons/dot.png"; // Invisible image 
      iconEnabled = "~/client/ui/tutorialImages/tutlassocombat.jpg"; // Icon image used as main image automatic resizing with resolution change.
      iconOffset = "0 0";
      extent = "128 230";
      position = %imagePos;
      input = "0";
      onTop = "0";
      HorizSizing = "relative";
      VertSizing = "relative";
   };
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALRAIDLASSO");
   tsAddTaskDialog("ID_TUTORIALRAIDLASSO", %dlgData);
   tsSetTaskDialogImage(%image1, %dlgData);
   tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
   tsDestroyTaskDlgData(%dlgData);
   //Quest log
   tsAddTaskToTracker("Combat Tutorial", "Lasso-select your two Gunslingers.", "Click and drag your pointer around the Gunslingers to select them both at once.");
}

function TutorialRaidConvert::onExit(%this)
{
   tsConvertObjTeam("Grubby", 2);
   tsEnableCommand(AttackCmdData, true);
   // Quest log
   tsAddTaskToTracker("Combat Tutorial", "Defeat the Bandit.", "Drag your Hero and Gunslingers onto the Bandit to attack and defeat him.");
}

function TutorialRaidDefeat::onExit(%this)
{
   if (isObject(Yance) == true)
   {  
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More, "ID_TUTORIALRAIDDEFEAT");
      tsAddTaskDialog("ID_TUTORIALRAIDDEFEAT", %dlgData);
      tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
      tsDestroyTaskDlgData(%dlgData);
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, $TaskButton::More, "ID_TUTORIALGunWork");
      tsAddTaskDialog("ID_TUTORIALGunWork", %dlgData);
      tsSendTaskDlgMsg(%dlgData, HeroCharacter.getId());
      tsDestroyTaskDlgData(%dlgData);
      %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALNoWork");
      tsAddTaskDialog("ID_TUTORIALNoWork", %dlgData);
      tsSendTaskDlgMsg(%dlgData, "Yance");
      tsDestroyTaskDlgData(%dlgData);
   }
   
   // Quest log
   tsCompleteTaskInTracker("Combat Tutorial", "Lasso-select your two Gunslingers.");
   tsCompleteTaskInTracker("Combat Tutorial", "Defeat the Bandit.");
   tsCompleteTaskInTracker("Combat Tutorial", "Defend your Gold Mine.");
   
   // Reward
   tsModifyResource($Resource::Experience, 5, true);
   SendProductionToClient(herocharacter, "5 experience");
}
// Updates Quest log Only
function TutorialGoldComplete::onUpdate(%this)
{
   %resourceCount = rsGetResourceCount($Resource::Gold);
   if(%resourceCount >= $tutGoldamt)
   {
      TaskModifier.StrMarkVertex("TutorialTasks", "TutorialGoldComplete", $TSV_CMPLETE);
      // Quest log
      tsCompleteTaskInTracker("Gold Resource Tutorial", "Collect "@$tutGoldamt@" Gold.");
   }
}

function TutorialGoldCombat::onUpdate(%this)
{
   %resourceCount = rsGetResourceCount($Resource::Gold);
   if(%resourceCount >= $tutGoldamt)
   {
      TaskModifier.StrMarkVertex("TutorialTasks", "TutorialGoldCombat", $TSV_CMPLETE);
   }
}
function TutorialGoldCompleteTwo::onExit(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", false, false, "ID_TUTORIALGOLDCOMPLETE");
   tsAddTaskDialog("ID_TUTORIALGOLDCOMPLETE", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "Settler1");
   tsDestroyTaskDlgData(%dlgData);
}

function TutorialComplete::onExit(%this)
{
   %dlgData = tsCreateTaskDlgData("ID_TASKNAME_TUT", true, true, "ID_TUTORIALCOMPLETE");
   tsAddTaskDialog("ID_TUTORIALCOMPLETE", %dlgData);
   tsSetAcceptButtonText("ID_ACCEPT_READY", %dlgData);
   tsSetCancelButtonText("ID_CANCEL_NOTYET", %dlgData);
   tsSendTaskDlgMsg(%dlgData, "herocharacter");
   tsDestroyTaskDlgData(%dlgData);
   
}

function StartLoad::onExit(%this)
{
   TaskModifier.StrMarkVertex("TutorialTasks", "TutorialStart", $TSV_CLOSED);
   tsUseTutorialMap(false);
   tsAwardBadge("badge_settler");
   %scenario = new SLScenario()
   {
     stack = false;
     mapName = "assets/data/missions/sandlot/mainmap.mis";
     mapMinimap = "assets/client/ui/minimaps/campaign1minimap.png";
     mapMain = true;

     resourceGold  = "400 1";
     resourceWood = "400 1";
     resourceFood = "20 1";
     resourceFoodMax = "20";
     resourceWater = "0 1";
     resourceWaterMax = "0";
     resourceHappiness = "80 1";
   };
   
   // load the scenario
   LoadScenario(%scenario, "", startCampaign1Tasks);
}

function startCampaign1Tasks()
{
   InitializeQuestGui();
   
   //Global Tasks 
   slgActivateTask("GlobalTasks", true);
   TaskModifier.strMarkVertex("GlobalTasks", "GlobalStartTasks", $TSV_AVAIL);
	
	//Badges
   slgActivateTask("Badgetasks", true);
   TaskModifier.strMarkVertex("Badgetasks", "BadgeStart", $TSV_AVAIL);
   
   //Badges (General)
   //slgActivateTask("Badgetasksgeneral");
   //TaskModifier.strMarkVertex("Badgetasksgeneral", "BadgeStartGeneral", $TSV_AVAIL);
   
   //Happiness Tasks
   slgActivateTask("Happinesstasks");
   TaskModifier.strMarkVertex("Happinesstasks", "HappinessTaskCounter", $TSV_AVAIL);
   
   //Starting Tasks
   slgActivateTask("StartTasks");
   TaskModifier.strMarkVertex("StartTasks", "StartStart", $TSV_AVAIL);
   
   //Mainmap map Tasks
   slgActivateTask("MainmapTasks");
   TaskModifier.strMarkVertex("MainmapTasks", "FoodLowTrigger", $TSV_AVAIL);
   
   //General Tasks 
   slgActivateTask("GeneralTasks");
   TaskModifier.strMarkVertex("GeneralTasks", "GeneralStart", $TSV_AVAIL);
   
   // initialize the world map images
   tutorialworldmap.visible = false;
   campaign1worldmap.visible = true;
   campaign2worldmap.visible = false;
   fullworldmap.visible = false;
   
   // intialize the campaign icons
   tutorialworldicon.visible = true;
   
   // update the satellite icons
   SetCampaign1Satellites(true);
}